export default defineEventHandler(async event => {
  const body = await readBody(event);
  try {
    const userInfo = await prisma.user.findUnique({
      where: {email: body.email},
      select: {theme: true},
    });
    if (userInfo) {
      return apiResponse({result: userInfo.theme});
    }
    return apiResponse({status: false, message: 'User not found'});
  } catch (error) {
    return apiResponse({status: false, message: 'User not found', error});
  }
});
