import { defineEventHandler, getQuery } from 'h3';

type getRequest = {
  page: number;
  limit?: number;
};

export default defineEventHandler(async (event) => {
  const method = event.method;
  const USER_ID = Number(event.context.user.id);
  const query: getRequest = getQuery(event);
  if (method == 'GET') return await getOrganization(USER_ID, query);
});

async function getOrganization(USER_ID: number, query: getRequest) {
  const page = query.page || 1;
  const limit = Number(query.limit) || 100;
  const skip = Number((page - 1) * limit);

  return await prisma.project
    .findMany({
      where: {
        OR: [
          {
            drawingEnter: {
              some: {
                userId: USER_ID,
              },
            },
          },
          {
            gameEnter: {
              some: {
                userId: USER_ID,
              },
            },
          },
          {
            contestEnter: {
              some: {
                userId: USER_ID,
              },
            },
          },
          {
            donations: {
              some: {
                userId: USER_ID,
              },
            },
          },
        ],
      },
      select: {
        coupons: {
          select: {
            id: true,
            name: true,
            logo: true,
            redeemed: {
              where: {
                userId: USER_ID,
              },
              select: {
                userId: true,
              },
            },
          },
        },
      },
      skip: skip,
      take: limit,
    })
    .then((data) => {
      if (data.length === 0) return [];
      const coupons: { id: number; name: string; logo: string; redeemed: boolean }[] = [];
      data.forEach((item) => {
        item.coupons.forEach((coupon) => {
          if (item.distribution == 'Correct Answers Only') {
            if (item.answers[0].correct)
              coupons.push({
                id: coupon.id,
                name: coupon.name,
                logo: coupon.logo,
                redeemed: false,
              });
          } else {
            coupons.push({
              id: coupon.id,
              name: coupon.name,
              logo: coupon.logo,
              redeemed: false,
            });
          }
        });
      });
      return coupons;
    });
}
