import { defineEventHandler, getQuery } from 'h3';

type getRequest = {
  page: number;
  limit?: number;
};

export default defineEventHandler(async (event) => {
  const method = event.method;
  const USER_ID = Number(event.context.user.id);
  const query: getRequest = getQuery(event);
  if (method == 'GET') return await getOrganization(USER_ID, query);
});

async function getOrganization(USER_ID: number, query: getRequest) {
  const page = query.page || 1;
  const limit = Number(query.limit) || 100;
  const skip = Number((page - 1) * limit);
  return await prisma.coupon
    .findMany({
      where: {
        redeemed: {
          some: {
            userId: USER_ID,
          },
        },
      },
      select: {
        id: true,
        logo: true,
        name: true,
      },
      skip: skip,
      take: limit,
    })
    .then((data: any) => {
      return {
        coupones: data,
        totalCount: data.length,
        page,
        totalPages: Math.ceil(data.length / limit),
      };
    })
    .catch((err: any) => {
      return {
        message: 'Error fetching project',
        error: err.message,
      };
    });
}
