export default defineEventHandler(async event => {
  const USER_ID = Number(event.context.user.id);
  const method = event.method;

  if (method == 'GET') {
    return await getUserPrifile(USER_ID);
  }
});

async function getUserPrifile(USER_ID: number) {
  const followed = await prisma.follow
    .findMany({
      where: {userId: USER_ID},
      select: {
        organization: {
          select: {
            id: true,
            orgName: true,
            photo: true,
            city: true,
            state: true,
            _count: {
              select: {
                projects: true,
                followers: true,
              },
            },
          },
        },
      },
    })
    .then(data => {
      return data == null ? [] : data;
    })
    .catch(() => {
      return [];
    });

  const users = await prisma.user.findMany({
    where: {
      followers: {
        some: {
          userId: USER_ID,
        },
      },
    },
    select: {
      city: true,
      state: true,
      orgName: true,
      projects: {
        where: {
          status: 'live',
        },
        select: {
          id: true,
          name: true,
          category: true,
          status: true,
        },
        take: 6,
      },
    },
  });

  if (followed || users) {
    return {
      status: true,
      organizations: followed.map(f => f.organization),
      projects: users.flatMap(u =>
        u.projects.map(p => ({
          ...p,
          city: u.city,
          state: u.state,
          org: u.orgName,
        }))
      ),
    };
  } else {
    return {status: false};
  }
}
