export default defineEventHandler(async event => {
  const USER_ID = Number(event.context.user.id);
  const method = event.method;

  if (method == 'GET') {
    return await getUserPrifile(USER_ID);
  }
});

async function getUserPrifile(USER_ID: number) {
  const User = await prisma.user.findUnique({
    where: {id: USER_ID},
    select: {
      photo: true,
      firstName: true,
      lastName: true,
      bio: true,
    },
  });

  const followed = await prisma.follow
    .findMany({
      where: {userId: USER_ID},
      select: {
        organization: {
          select: {
            id: true,
            orgName: true,
            photo: true,
            city: true,
            state: true,
            _count: {
              select: {
                projects: true,
                followers: true,
              },
            },
          },
        },
      },
    })
    .then(data => {
      return data == null ? [] : data;
    })
    .catch(() => {
      return [];
    });

  const coupons = await prisma.coupon.count({
    where: {
      projects: {
        some: {
          OR: [
            {drawingEnter: {some: {userId: USER_ID}}},
            {gameEnter: {some: {userId: USER_ID}}},
            {contestEnter: {some: {userId: USER_ID}}},
          ],
        },
      },
    },
  });

  const redeemed = await prisma.redeemed.findMany({
    where: {
      userId: USER_ID,
    },
    select: {
      coupon: {
        select: {
          id: true,
          name: true,
          logo: true,
          code: true,
          sponsor: {
            select: {
              name: true,
            },
          },
        },
      },
      createdAt: true,
    },
  });

  const contests = await prisma.contestEnter.findMany({
    where: {
      userId: USER_ID,
    },
    select: {
      project: {
        select: {
          id: true,
          name: true,
          category: true,
          type: true,
          status: true,
          createdAt: true,
        },
      },
    },
  });

  if (User) {
    return {status: true, user: User, followed: followed.map(f => f.organization), coupons, contests, redeemed};
  } else {
    return {status: false};
  }
}
