import { defineEventHandler } from 'h3';

export default defineEventHandler(async (event) => {
  const USER_ID = Number(event.context.user.id);

  return await prisma.follow
    .findMany({
      where: { userId: USER_ID },
      select: {
        organization: {
          select: {
            id: true,
            photo: true,
            orgName: true,
            city: true,
            state: true,
            raised: true,
            followers: {
              where: { userId: USER_ID },
              select: { id: true },
            },
            _count: {
              select: { followers: true, projects: true },
            },
          },
        },
      },
    })
    .then((data) => {
      data.forEach((item) => {
        item.organization.followed = item.organization.followers.length > 0;
        item.organization.projects = item.organization._count.projects;
        item.organization.followers = item.organization._count.followers;
        delete item.organization.followers;
        delete item.organization._count;
      });
      const result = data == null ? [] : data.map((item) => item.organization);
      return result;
    })
    .catch((error) => {
      console.error(`[followed.ts] Error fetching followed organizations:`, error);
      return [];
    });
});
