export default defineEventHandler(async event => {
  const USER_ID = Number(event.context.user.id);
  const method = event.method;

  if (method == 'GET') {
    return await getUserPrifile(USER_ID);
  }
});

async function getUserPrifile(USER_ID: number) {
  const donations = await prisma.donations
    .findMany({
      where: {userId: USER_ID},
      select: {
        amount: true,
        status: true,
        createdAt: true,
        project: {
          select: {
            name: true,
          },
        },
      },
    })
    .then(data => {
      return data == null ? [] : data;
    })
    .catch(() => {
      return [];
    });

  const total = await prisma.donations.aggregate({
    where: {userId: USER_ID, status: 'paid'},
    _sum: {
      amount: true,
    },
  });

  if (donations || total) {
    return {
      status: true,
      donations: donations,
      total: total._sum.amount || 0,
    };
  } else {
    return {status: false};
  }
}
