import {serverSupabaseClient} from '#supabase/server';
import {deleteCookie, getCookie, getRequestURL, sendRedirect} from 'h3';

export default defineEventHandler(async event => {
  const url = getRequestURL(event);
  const code = url.searchParams.get('code'); // from ?code=xxxxx
  if (!code) return sendRedirect(event, '/auth/signin?e=missing_code');
  const room = getCookie(event, 'goToRoom') || '';
  const supabase = await serverSupabaseClient(event);

  // Exchange code for session
  const {data: sessionData, error: exchangeError} = await supabase.auth.exchangeCodeForSession(code);

  if (exchangeError || !sessionData?.session) {
    return sendRedirect(event, '/auth/signin?e=auth');
  }

  const USER = sessionData.session.user;

  const USER_ID = USER.id;
  const userinfo = await prisma.user.findUnique({where: {uid: USER_ID}});

  if (!userinfo && USER_ID) {
    const fullName = USER.user_metadata?.full_name || '';
    const [firstName, lastName] = fullName.split(' ');
    const email = USER.user_metadata?.email || USER.email || '';
    const themeColor = USER.user_metadata?.theme_color || '';

    await prisma.user.create({
      data: {
        uid: USER_ID,
        type: 'user',
        firstName,
        lastName,
        email,
        themeColor,
      },
    });
  }
  deleteCookie(event, 'goToRoom');
  if (room && room != '') return sendRedirect(event, '/user/liveroom/' + room);
  return sendRedirect(event, '/user/');
});
