export interface ApiResponse<T = unknown> {
  result?: T;
  status?: boolean;
  message?: string;
  error?: T;
  meta?: {
    items?: number;
    page?: number;
    pages?: number;
  };
}

export const apiResponse = <T = unknown>({
  result,
  status = true,
  message,
  error,
  meta,
}: ApiResponse<T> = {}): ApiResponse<T> => {
  return {
    result,
    status,
    message,
    error,
    meta,
  };
};
