import { writeFileSync, existsSync, mkdirSync, unlinkSync, rmdirSync, readdirSync } from "fs";
import { join, dirname } from "path";

const UPLOAD_DIR = join(process.cwd(), "../uploads");
export const imageUpload = async (image: File, folder: string, type: string = "") => {
  const now = new Date();
  const month = now.getMonth() + 1;
  const year = now.getFullYear().toString();
  const first2char = type !== "" ? type.slice(0, 2) : folder.slice(0, 2);
  const subFolder = `${first2char}${month}`;

  const uploadPath = join(UPLOAD_DIR, folder, year, subFolder);
  if (!existsSync(uploadPath)) mkdirSync(uploadPath, { recursive: true });

  const fileBuffer = Buffer.from(await image.arrayBuffer());
  const ext = image.name.split(".").pop() || "webp";
  const fileName = `img${now.getTime()}${Math.random().toString(36).substring(2, 6)}.${ext}`;
  const filePath = join(uploadPath, fileName);

  try {
    writeFileSync(filePath, fileBuffer);
    return {
      status: true,
      file: `${folder}/${year}/${subFolder}/${fileName}`,
    };
  } catch (err) {
    return { status: false, message: "File save failed" };
  }
};

export const deleteImage = async (oldImage: string) => {
  try {
    const oldPath = join(UPLOAD_DIR, oldImage);
    unlinkSync(oldPath);
    const folderPath = dirname(oldPath);
    if (existsSync(folderPath) && readdirSync(folderPath).length === 0) rmdirSync(folderPath);
    return { status: true };
  } catch (error) {
    return { status: false, error };
  }
};

export const fileUpload = async (file: Blob, originalName: string, folder: string) => {
  const now = new Date();
  const month = String(now.getMonth() + 1).padStart(2, "0");
  const year = now.getFullYear().toString();
  const first2char = folder.slice(0, 2).toLowerCase();
  const subFolder = `${first2char}${month}${year}`;
  const uploadPath = join(UPLOAD_DIR, folder, subFolder);

  try {
    if (!existsSync(uploadPath)) {
      mkdirSync(uploadPath, { recursive: true });
    }
  } catch (error) {
    console.error("Error creating folder:", error);
    return { status: false, error: "Directory creation failed" };
  }

  const ext = originalName.split(".").pop()?.toLowerCase() || "bin";
  const fileName = `file${Date.now()}${Math.random().toString(36).slice(2, 6)}.${ext}`;
  const filePath = join(uploadPath, fileName);

  try {
    const buffer = Buffer.from(await file.arrayBuffer());
    writeFileSync(filePath, buffer);
    return {
      status: true,
      file: `${folder}/${subFolder}/${fileName}`,
    };
  } catch (err) {
    console.error("Error saving file:", err);
    return {
      status: false,
      error: "File save failed",
    };
  }
};
