import {Pool} from 'pg';
import {PrismaPg} from '@prisma/adapter-pg';
import {PrismaClient} from '~~/prisma/generated';

const prismaClientSingleton = () => {
  const pool = new Pool({connectionString: process.env.DATABASE_URL});
  const adapter = new PrismaPg(pool);
  return new PrismaClient({adapter, log: ['error']});
};

type PrismaClientSingleton = ReturnType<typeof prismaClientSingleton>;

const globalForPrisma = globalThis as unknown as {
  prisma: PrismaClientSingleton | undefined;
};

export const prisma = globalForPrisma.prisma ?? prismaClientSingleton();

if (process.env.NODE_ENV !== 'production') globalForPrisma.prisma = prisma;
