// utils/s3Client.ts
import { S3Client } from "@aws-sdk/client-s3";

export const getS3Client = () => {
  const config = useRuntimeConfig();

  return new S3Client({
    region: config.AWS_REGION,
    credentials: {
      accessKeyId: config.AWS_ACCESS_KEY_ID,
      secretAccessKey: config.AWS_SECRET_ACCESS_KEY,
    },
  });
};
